﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using usbLan;
using System.IO;
using System.IO.Ports;
using System.Net.Sockets;
using System.Net;
using System.Net.NetworkInformation;

namespace TestDll.controlInterface
{
    public partial class switchForm : Form
    {
        SerialPort usbPort = null;
        Socket tcpConnect = null;
        public switchForm()
        {
            InitializeComponent();
            cbbChannel.Items.Clear();
            rbUSB.Checked = true;
            gbUSBport.Enabled = true;
            gbLANport.Enabled = false;
            btRefreshCOMx_Click(null, null);
            btRefreshLocalIP_Click(null, null);
            for(int i=0;i<8;i++)
            {
                cbbChannel.Items.Add("J"+(i+1).ToString());
            }
            cbbChannel.Text = "J1";
        }
        private void comboBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
        }
        private void btRefreshCOMx_Click(object sender, EventArgs e)
        {
            cbbCOMx.Items.Clear();
            string[] comPorts = commonModule.getCOMnames();
            for (int i = 0; i < comPorts.Length; i++)
            {
                cbbCOMx.Items.Add(comPorts[i]);
            }
            cbbCOMx.Text = comPorts[0];
        }
        private void btRefreshLocalIP_Click(object sender, EventArgs e)
        {
            cbbLocalIP.Items.Clear();
            string[] localIPs = commonModule.getLocalIPs();
            for (int i = 0; i < localIPs.Length; i++)
            {
                cbbLocalIP.Items.Add(localIPs[i]);
            }
            cbbLocalIP.Text = localIPs[0];
        }
        private void rbUSB_Click(object sender, EventArgs e)
        {
            rbUSB.Checked = true;
            gbUSBport.Enabled = true;
            gbLANport.Enabled = false;
        }
        private void rbLan_Click(object sender, EventArgs e)
        {
            rbLan.Checked = true;
            gbUSBport.Enabled = false;
            gbLANport.Enabled = true;
        }
        private void btConnectDevice_Click(object sender, EventArgs e)
        {
            if(rbUSB.Checked)
            {
                if (btConnect.Text == "Connect Device")
                {
                    try
                    {
                        usbPort = usbLan.commonModule.openConnectUSB(cbbCOMx.Text, Convert.ToInt32(cbbBaud.Text));
                        tbDeviceInfos.Text = usbLan.commonModule.getProductInformationUSB(usbPort);
                        btConnect.Text = "Close Connect";
                        btConnect.ForeColor = Color.Red;
                        btConnect.BackColor = Color.LimeGreen;
                    }
                    catch
                    {
                        tbDeviceInfos.Text = "";
                        usbLan.commonModule.closeConnectUSB(usbPort);
                        MessageBox.Show("Connect failure!");
                    }
                }
                else
                {
                    try
                    {
                        usbLan.commonModule.closeConnectUSB(usbPort);
                        btConnect.Text = "Connect Device";
                        btConnect.ForeColor = Color.Blue;
                        btConnect.BackColor = Color.Transparent;
                        tbDeviceInfos.Text = "";
                    }
                    catch 
                    {
                        MessageBox.Show("Close failure!");
                    }
                }
            }
            else
            {
                if (btConnect.Text == "Connect Device")
                {
                    try
                    {
                        tcpConnect = usbLan.commonModule.openConnectTCP(cbbLocalIP.Text, tbDeviceIP.Text,Convert.ToInt32(nudDevicePort.Value));
                        tbDeviceInfos.Text = usbLan.commonModule.getProductInformationTCP(tcpConnect);
                        btConnect.Text = "Close Connect";
                        btConnect.ForeColor = Color.Red;
                        btConnect.BackColor = Color.LimeGreen;
                    }
                    catch
                    {
                        tbDeviceInfos.Text = "";
                        usbLan.commonModule.closeConnectTCP(tcpConnect);
                        MessageBox.Show("Connect failure!");
                    }
                }
                else
                {
                    try
                    {
                        usbLan.commonModule.closeConnectTCP(tcpConnect);
                        btConnect.Text = "Connect Device";
                        btConnect.ForeColor = Color.Blue;
                        btConnect.BackColor = Color.Transparent;
                        tbDeviceInfos.Text = "";
                    }
                    catch
                    {
                        MessageBox.Show("Close failure!");
                    }
                }
            }
        }
        private void btOpenChannel_Click_1(object sender, EventArgs e)
        {
            int openChannel = cbbChannel.SelectedIndex + 1;
            if (btOpenChannel.Text == "ON")
            {
                try
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.switchModule.openChannelUSB(usbPort, openChannel);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.switchModule.openChannelTCP(tcpConnect, openChannel);
                    }
                    btOpenChannel.Text = "OFF";
                    btOpenChannel.BackColor = Color.LimeGreen;
                }
                catch
                {
                    MessageBox.Show("Open channel failure!");
                }
            }
            else
            {
                try
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.switchModule.closeChannelUSB(usbPort);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.switchModule.closeChannelTCP(tcpConnect);
                    }
                    btOpenChannel.Text = "ON";
                    btOpenChannel.BackColor = Color.Transparent;
                }
                catch
                {
                    MessageBox.Show("Close channel failure!");
                }
            }
        }
        private void btSingleStart_Click(object sender, EventArgs e)
        {
            int cycleChannel = cbbChannel.SelectedIndex + 1;
            double cyclePeriod = Convert.ToDouble(nudPeriod.Value) ;
            double cycleWidth = Convert.ToDouble(nudWidth.Value);
            if (btSingleStart.Text == "Start")
            {
                try
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.switchModule.cycleChannelUSB(usbPort, cycleChannel, cyclePeriod, cycleWidth);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.switchModule.cycleChannelTCP(tcpConnect, cycleChannel, cyclePeriod, cycleWidth);
                    }
                    btSingleStart.Text = "Stop";
                    btSingleStart.BackColor = Color.LimeGreen;
                }
                catch
                {
                    MessageBox.Show("Cycle channel failure!");
                }
            }
            else
            {
                try
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.switchModule.closeChannelUSB(usbPort);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.switchModule.closeChannelTCP(tcpConnect);
                    }
                    btSingleStart.Text = "Start";
                    btSingleStart.BackColor = Color.Transparent;
                }
                catch
                {
                    MessageBox.Show("Stop channel failure!");
                }
            }
        }
        private void btMultiStart_Click(object sender, EventArgs e)
        {
            List<int> cycleChannels = new List<int>();
            foreach(Control channel in gbCycleMulti.Controls)
            {
                if(string.Compare(channel.Name.Substring(0,4),"cbCH") == 0)
                {
                    CheckBox cuChannel = channel as CheckBox;
                    if (cuChannel.Checked) 
                    {
                        cycleChannels.Add(Convert.ToInt32(cuChannel.Name.Substring(4, 1)));
                    }
                }
            }
            int[] cuCycleChannels = cycleChannels.ToArray();
            Array.Sort(cuCycleChannels);
            if (cbCH1.Checked) { cycleChannels.Add(1); }
            double cycleMultichannelWidth = Convert.ToDouble(nudMwidth.Value);
            if (btMultiStart.Text == "Start")
            {
                try
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.switchModule.cycleMultichannelUSB(usbPort, cuCycleChannels, cycleMultichannelWidth);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.switchModule.cycleMultichannelTCP(tcpConnect, cuCycleChannels, cycleMultichannelWidth);
                    }
                    btMultiStart.Text = "Stop";
                    btMultiStart.BackColor = Color.LimeGreen;
                }
                catch
                {
                    MessageBox.Show("Cycle channels failure!");
                }
            }
            else
            {
                try
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.switchModule.closeChannelUSB(usbPort);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.switchModule.closeChannelTCP(tcpConnect);
                    }
                    btMultiStart.Text = "Start";
                    btMultiStart.BackColor = Color.Transparent;
                }
                catch
                {
                    MessageBox.Show("Stop channels failure!");
                }
            }
        }
    }
}
